/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;

public final class AdapterUtil {
    private AdapterUtil() {
    }

    public static <T> T getAdapter(Object adaptable, Class<T> adapterClass) {
        Object adapter;
        if (adaptable instanceof IAdaptable && adapterClass.isInstance(adapter = ((IAdaptable)adaptable).getAdapter(adapterClass))) {
            return adapterClass.cast(adapter);
        }
        if (adaptable == null) {
            return null;
        }
        adapter = Platform.getAdapterManager().getAdapter(adaptable, adapterClass);
        if (adapterClass.isInstance(adapter)) {
            return adapterClass.cast(adapter);
        }
        return null;
    }

    public static boolean hasAdapter(Object adaptable, Class<?> adapterClass) {
        Object adapter;
        boolean hasAdapter = Platform.getAdapterManager().hasAdapter(adaptable, adapterClass.getName());
        if (hasAdapter) {
            return true;
        }
        return adaptable instanceof IAdaptable && adapterClass.isInstance(adapter = ((IAdaptable)adaptable).getAdapter(adapterClass));
    }

    public static <T> Collection<T> adaptAllTo(Collection<?> elements, Class<T> adapterClass) {
        if (elements == null) {
            return Collections.emptyList();
        }
        return AdapterUtil.adaptAllTo(elements.iterator(), adapterClass, new ArrayList(elements.size()));
    }

    public static <T, C extends Collection<? super T>> C adaptAllTo(Iterator<?> elements, Class<T> adapterClass, C adapters) {
        while (elements.hasNext()) {
            Object elem = elements.next();
            T adapter = AdapterUtil.getAdapter(elem, adapterClass);
            if (adapter == null) continue;
            adapters.add(adapter);
        }
        return adapters;
    }
}

