/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.resource;

import com.sun.javafx.tools.resource.PackagerResource;
import com.sun.javafx.tools.resource.ResourceFilter;
import com.sun.javafx.tools.resource.ResourceTraversal;
import java.io.File;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class ConsolidatedResources {
    private final SortedMap<ResourceKey, ResourceRecord> resourceMap = new TreeMap<ResourceKey, ResourceRecord>();

    public void addResource(PackagerResource packagerResource) {
        this.addResource(packagerResource, null);
    }

    public void addResource(PackagerResource packagerResource, ResourceFilter resourceFilter) {
        packagerResource.traverse(new ResourceRegistration(this.resourceMap), resourceFilter);
    }

    public boolean traverse(ResourceTraversal resourceTraversal) {
        for (Map.Entry<ResourceKey, ResourceRecord> entry : this.resourceMap.entrySet()) {
            ResourceRecord resourceRecord = entry.getValue();
            if (resourceTraversal.traverse(resourceRecord.getRootResource(), resourceRecord.getFile(), resourceRecord.getRelativePath())) continue;
            return false;
        }
        return true;
    }

    private static final class ResourceKey
    implements Comparable<ResourceKey> {
        private final String directory;
        private final String fileName;

        private ResourceKey(String string, String string2) {
            this.directory = string;
            this.fileName = string2;
        }

        public static ResourceKey forFile(String string) {
            int n = string.lastIndexOf(47);
            if (n == -1) {
                return new ResourceKey("", string);
            }
            return new ResourceKey(string.substring(0, n), string.substring(n + 1));
        }

        public static ResourceKey forDirectory(String string) {
            return new ResourceKey(string, "");
        }

        public String getDirectory() {
            return this.directory;
        }

        public String getFileName() {
            return this.fileName;
        }

        @Override
        public int compareTo(ResourceKey resourceKey) {
            int n = this.directory.compareTo(resourceKey.directory);
            return n != 0 ? n : this.fileName.compareTo(resourceKey.fileName);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ResourceKey)) {
                return false;
            }
            return this.compareTo((ResourceKey)object) == 0;
        }

        public int hashCode() {
            int n = 7;
            n = 97 * n + this.directory.hashCode();
            n = 97 * n + this.fileName.hashCode();
            return n;
        }
    }

    private static final class ResourceRecord {
        private final PackagerResource rootResource;
        private final File file;
        private final String relativePath;

        public ResourceRecord(PackagerResource packagerResource, File file, String string) {
            this.rootResource = packagerResource;
            this.file = file;
            this.relativePath = string;
        }

        public PackagerResource getRootResource() {
            return this.rootResource;
        }

        public File getFile() {
            return this.file;
        }

        public String getRelativePath() {
            return this.relativePath;
        }
    }

    private static final class ResourceRegistration
    implements ResourceTraversal {
        private final Map<ResourceKey, ResourceRecord> resourceMap;

        public ResourceRegistration(Map<ResourceKey, ResourceRecord> map) {
            this.resourceMap = map;
        }

        @Override
        public boolean traverse(PackagerResource packagerResource, File file, String string) {
            this.resourceMap.put(file.isDirectory() ? ResourceKey.forDirectory(string) : ResourceKey.forFile(string), new ResourceRecord(packagerResource, file, string));
            return true;
        }
    }
}

