/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.progress.spi;

import java.awt.EventQueue;
import java.util.LinkedHashSet;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.progress.spi.InternalHandle;

public final class TaskModel {
    private DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
    private final DefaultListModel model = new DefaultListModel();
    private InternalHandle explicit;
    private final LinkedHashSet<ListDataListener> dataListeners = new LinkedHashSet();
    private final LinkedHashSet<ListSelectionListener> selectionListeners = new LinkedHashSet();

    public TaskModel() {
        TaskListener taskListener = new TaskListener();
        this.model.addListDataListener(taskListener);
        this.selectionModel.addListSelectionListener(taskListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandle(InternalHandle internalHandle) {
        DefaultListModel defaultListModel = this.model;
        synchronized (defaultListModel) {
            this.model.addElement(internalHandle);
        }
        this.updateSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandle(InternalHandle internalHandle) {
        if (this.explicit == internalHandle) {
            this.explicit = null;
        }
        DefaultListModel defaultListModel = this.model;
        synchronized (defaultListModel) {
            this.model.removeElement(internalHandle);
        }
        this.updateSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSelection() {
        if (this.explicit != null) {
            return;
        }
        InternalHandle internalHandle = this.getSelectedHandle();
        if (internalHandle != null && !internalHandle.isInSleepMode()) {
            return;
        }
        InternalHandle internalHandle2 = null;
        DefaultListModel defaultListModel = this.model;
        synchronized (defaultListModel) {
            for (int i = 0; i < this.model.size(); ++i) {
                InternalHandle internalHandle3 = (InternalHandle)this.model.getElementAt(i);
                if (this.getSelectionRating(internalHandle3) < this.getSelectionRating(internalHandle2)) continue;
                internalHandle2 = internalHandle3;
            }
            if (internalHandle2 != null) {
                this.selectionModel.setSelectionInterval(this.model.indexOf(internalHandle2), this.model.indexOf(internalHandle2));
            } else {
                this.selectionModel.clearSelection();
            }
        }
    }

    private int getSelectionRating(InternalHandle internalHandle) {
        int n = 0;
        if (internalHandle != null) {
            if (!internalHandle.isInSleepMode()) {
                n += 4;
            }
            if (internalHandle.isUserInitialized()) {
                n += 2;
            }
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void explicitlySelect(InternalHandle internalHandle) {
        this.explicit = internalHandle;
        DefaultListModel defaultListModel = this.model;
        synchronized (defaultListModel) {
            int n = this.model.indexOf(this.explicit);
            if (n == -1) {
                return;
            }
            this.selectionModel.setSelectionInterval(n, n);
        }
    }

    public InternalHandle getExplicitSelection() {
        return this.explicit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        DefaultListModel defaultListModel = this.model;
        synchronized (defaultListModel) {
            return this.model.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalHandle[] getHandles() {
        Object[] objectArray;
        DefaultListModel defaultListModel = this.model;
        synchronized (defaultListModel) {
            objectArray = new InternalHandle[this.model.size()];
            this.model.copyInto(objectArray);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalHandle getSelectedHandle() {
        DefaultListModel defaultListModel = this.model;
        synchronized (defaultListModel) {
            int n = this.selectionModel.getMinSelectionIndex();
            if (n != -1 && n >= 0 && n < this.model.size()) {
                return (InternalHandle)this.model.getElementAt(n);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        LinkedHashSet<ListSelectionListener> linkedHashSet = this.selectionListeners;
        synchronized (linkedHashSet) {
            this.selectionListeners.add(listSelectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        LinkedHashSet<ListSelectionListener> linkedHashSet = this.selectionListeners;
        synchronized (linkedHashSet) {
            this.selectionListeners.remove(listSelectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListDataListener(ListDataListener listDataListener) {
        LinkedHashSet<ListDataListener> linkedHashSet = this.dataListeners;
        synchronized (linkedHashSet) {
            this.dataListeners.add(listDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListDataListener(ListDataListener listDataListener) {
        LinkedHashSet<ListDataListener> linkedHashSet = this.dataListeners;
        synchronized (linkedHashSet) {
            this.dataListeners.remove(listDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListDataListener[] getDataListeners() {
        LinkedHashSet<ListDataListener> linkedHashSet = this.dataListeners;
        synchronized (linkedHashSet) {
            return this.dataListeners.toArray(new ListDataListener[this.dataListeners.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListSelectionListener[] getSelectionListeners() {
        LinkedHashSet<ListSelectionListener> linkedHashSet = this.selectionListeners;
        synchronized (linkedHashSet) {
            return this.selectionListeners.toArray(new ListSelectionListener[this.selectionListeners.size()]);
        }
    }

    private class TaskListener
    implements ListDataListener,
    ListSelectionListener {
        private TaskListener() {
        }

        @Override
        public void intervalAdded(final ListDataEvent listDataEvent) {
            final ListDataListener[] listDataListenerArray = TaskModel.this.getDataListeners();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (ListDataListener listDataListener : listDataListenerArray) {
                        listDataListener.intervalAdded(listDataEvent);
                    }
                }
            });
        }

        @Override
        public void intervalRemoved(final ListDataEvent listDataEvent) {
            final ListDataListener[] listDataListenerArray = TaskModel.this.getDataListeners();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (ListDataListener listDataListener : listDataListenerArray) {
                        listDataListener.intervalRemoved(listDataEvent);
                    }
                }
            });
        }

        @Override
        public void contentsChanged(final ListDataEvent listDataEvent) {
            final ListDataListener[] listDataListenerArray = TaskModel.this.getDataListeners();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (ListDataListener listDataListener : listDataListenerArray) {
                        listDataListener.contentsChanged(listDataEvent);
                    }
                }
            });
        }

        @Override
        public void valueChanged(final ListSelectionEvent listSelectionEvent) {
            final ListSelectionListener[] listSelectionListenerArray = TaskModel.this.getSelectionListeners();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (ListSelectionListener listSelectionListener : listSelectionListenerArray) {
                        listSelectionListener.valueChanged(listSelectionEvent);
                    }
                }
            });
        }
    }
}

