/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.jobs;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.core.StatusFactory;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.FlightRecorderProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.RecordingProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.jobs.DumpRecordingJob;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.IServerHandle;
import com.jrockit.mc.rjmx.services.flr.IEventSettingsHolder;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import com.jrockit.mc.ui.misc.DialogToolkit;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import java.io.Closeable;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class StartRecordingJob
extends Job {
    private final Map<String, ?> m_recordingOptions;
    private final IEventSettingsHolder m_recordingSettings;
    private final MCFile m_path;
    private final FlightRecorderProvider m_recorder;
    private volatile boolean m_canceling;

    public StartRecordingJob(FlightRecorderProvider recorder, String name, Map<String, ?> recordingOptions, IEventSettingsHolder recordingSettings, MCFile path) {
        super(NLS.bind((String)Messages.RECORDING_JOB_NAME, (Object)name));
        this.m_recordingOptions = recordingOptions;
        this.m_recordingSettings = recordingSettings;
        this.m_path = path;
        this.m_recorder = recorder;
        this.setUser(true);
    }

    protected void canceling() {
        this.m_canceling = true;
        this.getThread().interrupt();
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        IRecordingDescriptor startedRecording;
        String connectionName;
        IConnectionHandle connection;
        block7: {
            connection = null;
            connectionName = null;
            startedRecording = null;
            connectionName = this.m_recorder.getServerHandle().getServerDescriptor().getDisplayName();
            connection = this.m_recorder.getServerHandle().connect(this.getName());
            IFlightRecorderService flightRecorderService = (IFlightRecorderService)connection.getServiceOrThrow(IFlightRecorderService.class);
            startedRecording = flightRecorderService.start(this.m_recordingOptions, this.m_recordingSettings);
            RecordingProvider recording = this.m_recorder.getRecording(startedRecording);
            recording.setDumpToFile(this.m_path);
            if (startedRecording.isContinuous()) break block7;
            IStatus iStatus2 = this.monitorRecording(recording, monitor, connection, flightRecorderService);
            IOToolkit.closeSilently((Closeable)connection);
            return iStatus2;
        }
        try {
            iStatus = Status.OK_STATUS;
        }
        catch (Exception e) {
            block9: {
                block8: {
                    IStatus iStatus3;
                    try {
                        IServerHandle.State state = this.m_recorder.getServerHandle().getState();
                        if (state != IServerHandle.State.DISPOSED) break block8;
                        iStatus3 = Status.OK_STATUS;
                    }
                    catch (Throwable throwable) {
                        IOToolkit.closeSilently(connection);
                        throw throwable;
                    }
                    IOToolkit.closeSilently((Closeable)connection);
                    return iStatus3;
                }
                if (startedRecording == null) break block9;
                this.showMonitoringWarning(startedRecording, connectionName, e);
                IStatus iStatus4 = Status.OK_STATUS;
                IOToolkit.closeSilently((Closeable)connection);
                return iStatus4;
            }
            this.showStartingWarning(connectionName, e);
            IStatus iStatus5 = Status.OK_STATUS;
            IOToolkit.closeSilently((Closeable)connection);
            return iStatus5;
        }
        IOToolkit.closeSilently((Closeable)connection);
        return iStatus;
    }

    private void showStartingWarning(final String connectionName, final Exception exception) {
        DisplayToolkit.safeAsyncExec((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                DialogToolkit.showException((Shell)Display.getCurrent().getActiveShell(), (String)Messages.START_RECORDING_JOB_SERVICE_ERROR_TITLE, (String)NLS.bind((String)Messages.START_RECORDING_JOB_SERVICE_ERROR_MESSAGE, (Object)connectionName), (Throwable)exception);
            }
        });
    }

    private void showMonitoringWarning(IRecordingDescriptor startedRecording, String connectionName, Exception e) {
        final String detailedMessage = NLS.bind((String)Messages.START_RECORDING_JOB_ERROR_WHILE_MONITORING_RECORDING_MESSAGE, (Object)startedRecording.getName(), (Object)connectionName);
        if (FlightRecorderUI.getDefault().getShowMonitoringWarning()) {
            ControlPanel.getDefault().getLogger().log(Level.WARNING, detailedMessage, e);
            DisplayToolkit.safeAsyncExec((Display)Display.getDefault(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    MessageDialogWithToggle warnDialog = MessageDialogWithToggle.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.START_RECORDING_JOB_ERROR_WHILE_MONITORING_RECORDING_TITLE, (String)detailedMessage, (String)com.jrockit.mc.flightrecorder.ui.messages.internal.Messages.PREFERENCES_SHOW_MONITORING_WARNING_TEXT, (boolean)true, null, null);
                    if (warnDialog.getReturnCode() == 0 && !warnDialog.getToggleState()) {
                        FlightRecorderUI.getDefault().setShowMonitoringWarning(false);
                    }
                }
            });
        } else {
            ControlPanel.getDefault().getLogger().log(Level.FINER, detailedMessage, e);
        }
    }

    private IStatus monitorRecording(RecordingProvider rec, IProgressMonitor monitor, IConnectionHandle connection, IFlightRecorderService flightRecorderService) throws Exception {
        block8: {
            String recordingName = rec.getRecordingDescriptor().getName();
            int totalWork = StartRecordingJob.calculateSeconds(rec.getRecordingDescriptor().getDuration());
            monitor.beginTask(recordingName, totalWork);
            int progress = 0;
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (rec.wasClosed()) {
                    monitor.done();
                    break block8;
                }
                if ((rec = this.m_recorder.findRecording(rec.getRecordingDescriptor().getId(), connection)) == null) break;
                if (rec.isStopped() || this.m_canceling) {
                    if (rec.isAlive()) {
                        flightRecorderService.stop(rec.getRecordingDescriptor());
                    }
                    new DumpRecordingJob(rec, rec.getDumpToFile()).schedule();
                    monitor.done();
                    break block8;
                }
                float duration = rec.getRecordingDescriptor().getDuration();
                float partOfWorkDone = duration > 0.0f ? 1.0f - (float)rec.getTimeRemaining() / duration : 0.0f;
                int newProgress = Math.round((float)totalWork * partOfWorkDone);
                int worked = newProgress - progress;
                progress = newProgress;
                try {
                    monitor.worked(worked);
                }
                catch (RuntimeException e) {
                    ControlPanel.getDefault().getLogger().log(Level.WARNING, "Could not update progress", e);
                }
            }
            monitor.done();
            return StatusFactory.createErr((String)NLS.bind((String)Messages.START_FLIGHT_RECORDING_JOB_MISSING_RECORDING, (Object)recordingName));
        }
        return Status.OK_STATUS;
    }

    private static int calculateSeconds(long ms) {
        return (int)Math.min(ms / 1000L, Integer.MAX_VALUE);
    }
}

