/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.association.utility;

import com.sun.deploy.association.Action;
import com.sun.deploy.association.utility.GnomeVfsWrapper;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class GnomeAssociationUtil {
    public static final String GNOME_VFS_MIME_KEY_DESCRIPTION = "description";
    public static final String GNOME_VFS_MIME_KEY_ICON_FILENAME = "icon_filename";

    private GnomeAssociationUtil() {
    }

    public static String getMimeTypeByFileExt(String string) {
        String string2 = null;
        String[] stringArray = GnomeVfsWrapper.gnome_vfs_get_registered_mime_types();
        if (stringArray == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            String[] stringArray2 = GnomeVfsWrapper.gnome_vfs_mime_get_extensions_list(string3);
            if (stringArray2 != null) {
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (!stringArray2[j].equals(string)) continue;
                    string2 = stringArray[i];
                    break;
                }
            }
            if (string2 != null) break;
        }
        return string2;
    }

    public static List getFileExtListByMimeType(String string) {
        String[] stringArray = GnomeVfsWrapper.gnome_vfs_mime_get_extensions_list(string);
        if (stringArray == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public static String getIconFileNameByMimeType(String string) {
        return GnomeVfsWrapper.gnome_vfs_mime_get_icon(string);
    }

    public static String getDescriptionByMimeType(String string) {
        return GnomeVfsWrapper.gnome_vfs_mime_get_description(string);
    }

    public static List getActionListByMimeType(String string) {
        String string2;
        ArrayList<Action> arrayList = new ArrayList<Action>();
        Action action = null;
        String[] stringArray = GnomeVfsWrapper.gnome_vfs_mime_get_key_list(string);
        if (stringArray != null) {
            string2 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = GnomeVfsWrapper.gnome_vfs_mime_get_value(string, stringArray[i]);
                if (string2 == null) continue;
                action = new Action(stringArray[i], string2);
                arrayList.add(action);
            }
        }
        if ((string2 = GnomeVfsWrapper.gnome_vfs_mime_get_default_application_command(string)) != null) {
            arrayList.add(new Action("open", string2));
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    public static String getMimeTypeByURL(URL uRL) {
        return GnomeVfsWrapper.gnome_vfs_get_mime_type(uRL.toString());
    }

    public static boolean isMimeTypeExist(String string) {
        boolean bl = false;
        String[] stringArray = GnomeVfsWrapper.gnome_vfs_get_registered_mime_types();
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isFileExtExist(String string) {
        return GnomeAssociationUtil.getMimeTypeByFileExt(string) != null;
    }

    public static String getEnv(String string) {
        return GnomeVfsWrapper.getEnv(string);
    }

    public static boolean supportsCurrentPlatform() {
        String string = GnomeVfsWrapper.getVersion();
        return string != null && GnomeAssociationUtil.compareVersion(string, "2.6") <= 0;
    }

    public static boolean isAssociationSupported() {
        String string = GnomeVfsWrapper.getVersion();
        return string != null && GnomeAssociationUtil.compareVersion(string, "2.8") < 0;
    }

    public static int compareVersion(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        int n = 0;
        while (stringTokenizer.hasMoreTokens() && n == 0) {
            if (stringTokenizer2.hasMoreTokens()) {
                n = Integer.parseInt(stringTokenizer.nextToken()) - Integer.parseInt(stringTokenizer2.nextToken());
                continue;
            }
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        while (n == 0 && stringTokenizer2.hasMoreTokens()) {
            n = 0 - Integer.parseInt(stringTokenizer2.nextToken());
        }
        return n;
    }

    public static boolean isGnome26OrLater() {
        String string = GnomeVfsWrapper.getVersion();
        return string != null && GnomeAssociationUtil.compareVersion(string, "2.6") < 0;
    }
}

