/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.attributes;

import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.KindOfQuantity;
import com.jrockit.mc.common.unit.LinearKindOfQuantity;
import com.jrockit.mc.common.unit.LinearQuantity;
import com.jrockit.mc.common.unit.LinearUnit;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.ui.attributes.Messages;
import com.jrockit.mc.rjmx.ui.attributes.QuantityInputDialog;
import com.jrockit.mc.rjmx.ui.attributes.ReadOnlyMRIAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SetUnitMenuManager
extends MenuManager {
    private final IConnectionHandle m_connection;
    MenuManager m_supermenu;
    Collection<ReadOnlyMRIAttribute> m_selectedAttributes = Collections.emptyList();
    Map<String, Action> m_unitActions;
    private final Map<KindOfQuantity<?>, CustomUnitAction> m_customActions;
    Action m_rawAction;

    public SetUnitMenuManager(ISelectionProvider selectionProvider, IConnectionHandle connection, MenuManager supermenu) {
        super(Messages.SetUnitMenuManager_SET_UNIT_MENU_ITEM);
        this.setVisible(false);
        this.m_connection = connection;
        this.m_supermenu = supermenu;
        this.m_unitActions = new HashMap<String, Action>();
        this.m_customActions = new HashMap();
        this.m_rawAction = new Action(Messages.SetUnitMenuManager_RAW_VALUE_MENU_ITEM){

            public void run() {
                SetUnitMenuManager.this.setUnit(SetUnitMenuManager.this.m_selectedAttributes, null);
                SetUnitMenuManager.this.uncheckAllUnitActions();
                this.setChecked(true);
            }
        };
        this.add((IAction)this.m_rawAction);
        for (KindOfQuantity contentType : UnitLookup.getKindsOfQuantity()) {
            String label = NLS.bind((String)Messages.SetUnitMenuManager_KIND_OF_QUANTITY_BY_MULTIPLYING_WITH_MSG, (Object)contentType.getName());
            MenuManager typeManager = new MenuManager(label);
            for (final IUnit unit : contentType.getCommonUnits()) {
                Action action = new Action(unit.getLocalizedDescription(), 2){

                    public void run() {
                        SetUnitMenuManager.this.setUnit(SetUnitMenuManager.this.m_selectedAttributes, unit);
                        SetUnitMenuManager.this.uncheckAllUnitActions();
                        this.setChecked(true);
                    }
                };
                this.m_unitActions.put(UnitLookup.getUnitIdentifier((IUnit)unit), action);
                typeManager.add((IAction)action);
            }
            if (contentType instanceof LinearKindOfQuantity) {
                LinearKindOfQuantity kindOfQuantity = (LinearKindOfQuantity)contentType;
                CustomUnitAction action = new CustomUnitAction(kindOfQuantity);
                this.m_customActions.put((KindOfQuantity<?>)kindOfQuantity, action);
                typeManager.add((IAction)action);
            }
            this.add((IContributionItem)typeManager);
        }
        selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IMRIMetaDataService infoService = (IMRIMetaDataService)SetUnitMenuManager.this.m_connection.getServiceOrNull(IMRIMetaDataService.class);
                if (infoService != null && SetUnitMenuManager.this.selectionIsNumeric(infoService, event)) {
                    SetUnitMenuManager.this.m_selectedAttributes = SetUnitMenuManager.this.selectedAttributes(event);
                    SetUnitMenuManager.this.checkSelectedUnitAction(infoService);
                    SetUnitMenuManager.this.setVisible(true);
                } else {
                    SetUnitMenuManager.this.setVisible(false);
                }
                SetUnitMenuManager.this.m_supermenu.update(true);
            }
        });
    }

    private void setUnit(Collection<ReadOnlyMRIAttribute> m_selectedAttributes, IUnit<?> unit) {
        IMRIMetaDataService infoService;
        String unitIdentifier = null;
        if (unit != null) {
            unitIdentifier = UnitLookup.getUnitIdentifier(unit);
        }
        if ((infoService = (IMRIMetaDataService)this.m_connection.getServiceOrNull(IMRIMetaDataService.class)) != null) {
            for (ReadOnlyMRIAttribute attribute : m_selectedAttributes) {
                infoService.setMetaData(attribute.getMRI(), "UnitString", (Object)unitIdentifier);
            }
        }
    }

    private Collection<ReadOnlyMRIAttribute> selectedAttributes(SelectionChangedEvent event) {
        ArrayList<ReadOnlyMRIAttribute> attributes = new ArrayList<ReadOnlyMRIAttribute>();
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        for (Object selectedObject : selection) {
            if (!(selectedObject instanceof ReadOnlyMRIAttribute)) continue;
            attributes.add((ReadOnlyMRIAttribute)((Object)selectedObject));
        }
        return attributes;
    }

    /*
     * Unable to fully structure code
     */
    private boolean selectionIsNumeric(IMRIMetaDataService infoService, SelectionChangedEvent event) {
        selection = (StructuredSelection)event.getSelection();
        selectionIterator = selection.iterator();
        if (selectionIterator.hasNext()) ** GOTO lbl11
        return false;
lbl-1000:
        // 1 sources

        {
            selectedObject = selectionIterator.next();
            if (selectedObject instanceof ReadOnlyMRIAttribute) {
                attribute = (ReadOnlyMRIAttribute)selectedObject;
                if (MRIMetaDataToolkit.isNumerical((IMRIMetaData)infoService.getMetaData(attribute.getMRI()))) continue;
                return false;
            }
            return false;
lbl11:
            // 2 sources

            ** while (selectionIterator.hasNext())
        }
lbl12:
        // 1 sources

        return true;
    }

    private void checkSelectedUnitAction(IMRIMetaDataService infoService) {
        HashSet<String> selectedUnits = new HashSet<String>();
        for (ReadOnlyMRIAttribute attribute : this.m_selectedAttributes) {
            selectedUnits.add(infoService.getMetaData(attribute.getMRI()).getUnitString());
        }
        this.uncheckAllUnitActions();
        if (selectedUnits.size() == 1) {
            for (String selectedUnit : selectedUnits) {
                CustomUnitAction custAction;
                IUnit unit;
                Action action;
                Action action2 = action = selectedUnit == null ? this.m_rawAction : this.m_unitActions.get(selectedUnit);
                if (action == null && (unit = UnitLookup.getUnitOrNull((String)selectedUnit)) instanceof LinearUnit && (custAction = this.m_customActions.get(unit.getContentType())) != null) {
                    custAction.setUnit((LinearUnit)unit);
                    action = custAction;
                }
                if (action == null) continue;
                action.setChecked(true);
            }
        }
    }

    private void uncheckAllUnitActions() {
        this.m_rawAction.setChecked(false);
        for (Action action : this.m_unitActions.values()) {
            action.setChecked(false);
        }
        for (Action action : this.m_customActions.values()) {
            action.setChecked(false);
        }
    }

    private class CustomUnitAction
    extends Action {
        private final LinearKindOfQuantity kindOfQuantity;
        private LinearUnit unit;

        private CustomUnitAction(LinearKindOfQuantity kindOfQuantity) {
            super(Messages.SetUnitMenuManager_CUSTOM_UNIT_MENU_ITEM, 2);
            this.kindOfQuantity = kindOfQuantity;
        }

        private void setUnit(LinearUnit unit) {
            this.unit = unit;
            if (unit != null) {
                this.setText(NLS.bind((String)Messages.SetUnitMenuManager_CUSTOM_UNIT_MENU_ITEM_MSG, (Object)unit.getLocalizedDescription()));
            } else {
                this.setText(Messages.SetUnitMenuManager_CUSTOM_UNIT_MENU_ITEM);
            }
        }

        public void run() {
            LinearUnit initialUnit = this.unit != null ? this.unit : this.kindOfQuantity.getDefaultUnit();
            LinearQuantity initialQuantity = initialUnit.asWellKnownQuantity();
            Shell shell = Display.getCurrent().getActiveShell();
            LinearQuantity quantity = QuantityInputDialog.promptForCustomUnit(shell, initialQuantity);
            if (quantity != null) {
                String id = quantity.persistableString();
                LinearUnit newUnit = this.kindOfQuantity.getCachedUnit((Object)id);
                if (newUnit == null) {
                    newUnit = this.kindOfQuantity.makeCustomUnit(quantity);
                }
                SetUnitMenuManager.this.setUnit(SetUnitMenuManager.this.m_selectedAttributes, (IUnit)newUnit);
                SetUnitMenuManager.this.uncheckAllUnitActions();
                this.setUnit(newUnit);
                this.setChecked(true);
            }
        }
    }
}

