/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.CreateTableNode;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FKConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.GenerationClauseNode;
import org.apache.derby.impl.sql.compile.ModifyColumnNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.TableElementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.ConstraintInfo;
import org.apache.derby.impl.sql.execute.IndexConstantAction;

class TableElementList
extends QueryTreeNodeVector<TableElementNode> {
    private int numColumns;
    private TableDescriptor td;

    public TableElementList(ContextManager contextManager) {
        super(TableElementNode.class, contextManager);
    }

    void addTableElement(TableElementNode tableElementNode) {
        this.addElement(tableElementNode);
        if (tableElementNode instanceof ColumnDefinitionNode || tableElementNode.getElementType() == 7) {
            ++this.numColumns;
        }
    }

    void setCollationTypesOnCharacterStringColumns(SchemaDescriptor schemaDescriptor) throws StandardException {
        for (TableElementNode tableElementNode : this) {
            if (!(tableElementNode instanceof ColumnDefinitionNode)) continue;
            this.setCollationTypeOnCharacterStringColumn(schemaDescriptor, (ColumnDefinitionNode)tableElementNode);
        }
    }

    void setCollationTypeOnCharacterStringColumn(SchemaDescriptor schemaDescriptor, ColumnDefinitionNode columnDefinitionNode) throws StandardException {
        int n = schemaDescriptor.getCollationType();
        DataTypeDescriptor dataTypeDescriptor = columnDefinitionNode.getType();
        if (dataTypeDescriptor == null) {
            if (!columnDefinitionNode.hasGenerationClause()) {
                throw StandardException.newException("42XA9", columnDefinitionNode.getColumnName());
            }
        } else if (dataTypeDescriptor.getTypeId().isStringTypeId()) {
            columnDefinitionNode.setCollationType(n);
        }
    }

    void validate(DDLStatementNode dDLStatementNode, DataDictionary dataDictionary, TableDescriptor tableDescriptor) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList;
        this.td = tableDescriptor;
        int n = 0;
        int n2 = this.size();
        HashSet<String> hashSet = new HashSet<String>(n2 + 2, 0.999f);
        HashSet<String> hashSet2 = new HashSet<String>(n2 + 2, 0.999f);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (tableDescriptor != null && (constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor)) != null) {
            for (int i = 0; i < constraintDescriptorList.size(); ++i) {
                ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i);
                if (constraintDescriptor.getConstraintType() != 2 && constraintDescriptor.getConstraintType() != 3) continue;
                arrayList.add(constraintDescriptor);
            }
        }
        int n3 = 0;
        if (dDLStatementNode instanceof CreateTableNode) {
            n3 = ((CreateTableNode)dDLStatementNode).tableType;
        }
        for (TableElementNode tableElementNode : this) {
            Object object;
            String string;
            Object object2;
            Object object3;
            if (tableElementNode instanceof ColumnDefinitionNode) {
                object3 = (ColumnDefinitionNode)tableElementNode;
                if (n3 == 3 && (((ColumnDefinitionNode)object3).getType().getTypeId().isLongConcatableTypeId() || ((ColumnDefinitionNode)object3).getType().getTypeId().isUserDefinedTypeId())) {
                    throw StandardException.newException("42962", ((ColumnDefinitionNode)object3).getColumnName());
                }
                this.checkForDuplicateColumns(dDLStatementNode, hashSet, ((ColumnDefinitionNode)object3).getColumnName());
                ((ColumnDefinitionNode)object3).checkUserType(tableDescriptor);
                ((ColumnDefinitionNode)object3).bindAndValidateDefault(dataDictionary, tableDescriptor);
                ((ColumnDefinitionNode)object3).validateAutoincrement(dataDictionary, tableDescriptor, n3);
                if (tableElementNode instanceof ModifyColumnNode) {
                    object2 = (ModifyColumnNode)object3;
                    ((ModifyColumnNode)object2).checkExistingConstraints(tableDescriptor);
                    ((ModifyColumnNode)object2).useExistingCollation(tableDescriptor);
                } else if (((ColumnDefinitionNode)object3).isAutoincrementColumn()) {
                    ++n;
                }
            } else if (tableElementNode.getElementType() == 7) {
                object3 = tableElementNode.getName();
                if (tableDescriptor.getColumnDescriptor((String)object3) != null) break;
                throw StandardException.newException("42X14", object3, tableDescriptor.getQualifiedName());
            }
            if (!tableElementNode.hasConstraint()) continue;
            object3 = (ConstraintDefinitionNode)tableElementNode;
            ((ConstraintDefinitionNode)object3).bind(dDLStatementNode, dataDictionary);
            if (((ConstraintDefinitionNode)object3).getConstraintType() == 2 || ((ConstraintDefinitionNode)object3).getConstraintType() == 3) {
                string = null;
                object = null;
                for (int i = 0; i < arrayList.size(); ++i) {
                    Object object4;
                    object2 = arrayList.get(i);
                    if (object2 instanceof ConstraintDefinitionNode) {
                        object4 = (ConstraintDefinitionNode)object2;
                        string = ((ConstraintDefinitionNode)object4).getConstraintMoniker();
                        object = ((ConstraintDefinitionNode)object4).getColumnList().getColumnNames();
                    } else if (object2 instanceof ConstraintDescriptor) {
                        object4 = (ConstraintDescriptor)object2;
                        string = ((ConstraintDescriptor)object4).getConstraintName();
                        object = ((ConstraintDescriptor)object4).getColumnDescriptors().getColumnNames();
                    }
                    if (!this.columnsMatch(((ConstraintDefinitionNode)object3).getColumnList().getColumnNames(), (String[])object)) continue;
                    throw StandardException.newException("42Z93", ((ConstraintDefinitionNode)object3).getConstraintMoniker(), string);
                }
                arrayList.add(object3);
            }
            this.checkForDuplicateConstraintNames(dDLStatementNode, hashSet2, ((ConstraintDefinitionNode)object3).getConstraintMoniker());
            if ((((ConstraintDefinitionNode)object3).getConstraintType() == 5 || ((ConstraintDefinitionNode)object3).getConstraintType() == 7) && (object2 = ((ConstraintDefinitionNode)object3).getConstraintMoniker()) != null) {
                string = ((ConstraintDefinitionNode)object3).getDropSchemaName();
                object = string == null ? tableDescriptor.getSchemaDescriptor() : this.getSchemaDescriptor(string);
                ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptorByName(tableDescriptor, (SchemaDescriptor)object, (String)object2, false);
                if (constraintDescriptor == null) {
                    throw StandardException.newException("42X86", ((SchemaDescriptor)object).getSchemaName() + "." + (String)object2, tableDescriptor.getQualifiedName());
                }
                this.getCompilerContext().createDependency(constraintDescriptor);
            }
            if (((ConstraintDefinitionNode)object3).hasPrimaryKeyConstraint()) {
                this.verifyUniqueColumnList(dDLStatementNode, (ConstraintDefinitionNode)object3);
                continue;
            }
            if (((ConstraintDefinitionNode)object3).hasUniqueKeyConstraint()) {
                this.verifyUniqueColumnList(dDLStatementNode, (ConstraintDefinitionNode)object3);
                if (dataDictionary.checkVersion(160, null)) continue;
                this.checkForNullColumns((ConstraintDefinitionNode)object3, tableDescriptor);
                continue;
            }
            if (!((ConstraintDefinitionNode)object3).hasForeignKeyConstraint()) continue;
            this.verifyUniqueColumnList(dDLStatementNode, (ConstraintDefinitionNode)object3);
        }
        if (n > 1) {
            throw StandardException.newException("428C1", new Object[0]);
        }
    }

    public void validatePrimaryKeyNullability() throws StandardException {
        for (TableElementNode tableElementNode : this) {
            ConstraintDefinitionNode constraintDefinitionNode;
            if (!tableElementNode.hasConstraint() || !(constraintDefinitionNode = (ConstraintDefinitionNode)tableElementNode).hasPrimaryKeyConstraint()) continue;
            if (this.td == null) {
                this.setColumnListToNotNull(constraintDefinitionNode);
                continue;
            }
            this.checkForNullColumns(constraintDefinitionNode, this.td);
        }
    }

    int countConstraints(int n) {
        int n2 = 0;
        for (TableElementNode tableElementNode : this) {
            if (!(tableElementNode instanceof ConstraintDefinitionNode) || ((ConstraintDefinitionNode)tableElementNode).getConstraintType() != n) continue;
            ++n2;
        }
        return n2;
    }

    int countGenerationClauses() {
        int n = 0;
        for (TableElementNode tableElementNode : this) {
            if (!(tableElementNode instanceof ColumnDefinitionNode) || !((ColumnDefinitionNode)tableElementNode).hasGenerationClause()) continue;
            ++n;
        }
        return n;
    }

    int countNumberOfColumns() {
        return this.numColumns;
    }

    int genColumnInfos(ColumnInfo[] columnInfoArray) throws StandardException {
        int n = 0;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            Object object;
            if (((TableElementNode)this.elementAt(i)).getElementType() == 7) {
                object = ((TableElementNode)this.elementAt(i)).getName();
                columnInfoArray[i] = new ColumnInfo((String)object, this.td.getColumnDescriptor((String)object).getType(), null, null, null, null, null, 1, 0L, 0L, 0L);
                break;
            }
            if (!(this.elementAt(i) instanceof ColumnDefinitionNode)) {
                ++n;
                continue;
            }
            object = (ColumnDefinitionNode)this.elementAt(i);
            ProviderList providerList = null;
            ProviderInfo[] providerInfoArray = null;
            if (((ColumnDefinitionNode)object).hasGenerationClause()) {
                providerList = ((ColumnDefinitionNode)object).getGenerationClauseNode().getAuxiliaryProviderList();
            }
            if (providerList != null && providerList.size() > 0) {
                DependencyManager dependencyManager = this.getDataDictionary().getDependencyManager();
                providerInfoArray = dependencyManager.getPersistentProviderInfos(providerList);
            }
            columnInfoArray[i - n] = new ColumnInfo(((ColumnDefinitionNode)object).getColumnName(), ((ColumnDefinitionNode)object).getType(), ((ColumnDefinitionNode)object).getDefaultValue(), ((ColumnDefinitionNode)object).getDefaultInfo(), providerInfoArray, null, ((ColumnDefinitionNode)object).getOldDefaultUUID(), ((ColumnDefinitionNode)object).getAction(), ((ColumnDefinitionNode)object).isAutoincrementColumn() ? ((ColumnDefinitionNode)object).getAutoincrementStart() : 0L, ((ColumnDefinitionNode)object).isAutoincrementColumn() ? ((ColumnDefinitionNode)object).getAutoincrementIncrement() : 0L, ((ColumnDefinitionNode)object).isAutoincrementColumn() ? ((ColumnDefinitionNode)object).getAutoinc_create_or_modify_Start_Increment() : -1L);
            if (!((TableElementNode)object).hasConstraint()) continue;
            ++n;
        }
        return n;
    }

    void appendNewColumnsToRCL(FromBaseTable fromBaseTable) throws StandardException {
        int n = this.size();
        ResultColumnList resultColumnList = fromBaseTable.getResultColumns();
        TableName tableName = fromBaseTable.getTableName();
        for (int i = 0; i < n; ++i) {
            if (!(this.elementAt(i) instanceof ColumnDefinitionNode)) continue;
            ColumnDefinitionNode columnDefinitionNode = (ColumnDefinitionNode)this.elementAt(i);
            BaseColumnNode baseColumnNode = new BaseColumnNode(columnDefinitionNode.getColumnName(), tableName, columnDefinitionNode.getType(), this.getContextManager());
            ResultColumn resultColumn = new ResultColumn(columnDefinitionNode.getType(), (ValueNode)baseColumnNode, this.getContextManager());
            resultColumn.setName(columnDefinitionNode.getColumnName());
            resultColumnList.addElement(resultColumn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindAndValidateCheckConstraints(FromList fromList) throws StandardException {
        FromBaseTable fromBaseTable = (FromBaseTable)fromList.elementAt(0);
        CompilerContext compilerContext = this.getCompilerContext();
        ArrayList<AggregateNode> arrayList = new ArrayList<AggregateNode>();
        for (TableElementNode tableElementNode : this) {
            Object object;
            ConstraintDefinitionNode constraintDefinitionNode;
            if (!(tableElementNode instanceof ConstraintDefinitionNode) || (constraintDefinitionNode = (ConstraintDefinitionNode)tableElementNode).getConstraintType() != 4) continue;
            ValueNode valueNode = constraintDefinitionNode.getCheckCondition();
            int n = compilerContext.getReliability();
            try {
                object = new ProviderList();
                ProviderList providerList = compilerContext.getCurrentAuxiliaryProviderList();
                compilerContext.setCurrentAuxiliaryProviderList((ProviderList)object);
                compilerContext.setReliability(18041);
                valueNode = valueNode.bindExpression(fromList, null, arrayList);
                if (!arrayList.isEmpty()) {
                    throw StandardException.newException("42Y01", constraintDefinitionNode.getConstraintText());
                }
                valueNode = valueNode.checkIsBoolean();
                constraintDefinitionNode.setCheckCondition(valueNode);
                if (((Hashtable)object).size() > 0) {
                    constraintDefinitionNode.setAuxiliaryProviderList((ProviderList)object);
                }
                compilerContext.setCurrentAuxiliaryProviderList(providerList);
            }
            finally {
                compilerContext.setReliability(n);
            }
            object = fromBaseTable.getResultColumns();
            int n2 = ((ResultColumnList)object).countReferencedColumns();
            ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
            ((ResultColumnList)object).copyReferencedColumnsToNewList(resultColumnList);
            if (constraintDefinitionNode.getColumnList() != null) {
                String string = ((ResultColumn)constraintDefinitionNode.getColumnList().elementAt(0)).getName();
                if (n2 > 1 || !string.equals(((ResultColumn)resultColumnList.elementAt(0)).getName())) {
                    throw StandardException.newException("42621", string);
                }
            }
            constraintDefinitionNode.setColumnList(resultColumnList);
            ((ResultColumnList)object).clearColumnReferences();
            constraintDefinitionNode.qualifyNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindAndValidateGenerationClauses(SchemaDescriptor schemaDescriptor, FromList fromList, FormatableBitSet formatableBitSet, TableDescriptor tableDescriptor) throws StandardException {
        FromBaseTable fromBaseTable = (FromBaseTable)fromList.elementAt(0);
        ResultColumnList resultColumnList = fromBaseTable.getResultColumns();
        int n = fromBaseTable.getResultColumns().size();
        this.findIllegalGenerationReferences(fromList, tableDescriptor);
        formatableBitSet.grow(n + 1);
        CompilerContext compilerContext = this.getCompilerContext();
        ArrayList<AggregateNode> arrayList = new ArrayList<AggregateNode>();
        for (TableElementNode tableElementNode : this) {
            String[] stringArray;
            Object object;
            Object object2;
            ColumnDefinitionNode columnDefinitionNode;
            if (!(tableElementNode instanceof ColumnDefinitionNode) || !(columnDefinitionNode = (ColumnDefinitionNode)tableElementNode).hasGenerationClause()) continue;
            GenerationClauseNode generationClauseNode = columnDefinitionNode.getGenerationClauseNode();
            int n2 = compilerContext.getReliability();
            ProviderList providerList = compilerContext.getCurrentAuxiliaryProviderList();
            try {
                object2 = new ProviderList();
                compilerContext.setCurrentAuxiliaryProviderList((ProviderList)object2);
                compilerContext.setReliability(30329);
                ValueNode valueNode = generationClauseNode.bindExpression(fromList, null, arrayList);
                SelectNode.checkNoWindowFunctions(generationClauseNode, "generation clause");
                DataTypeDescriptor dataTypeDescriptor = valueNode.getTypeServices();
                object = columnDefinitionNode.getType();
                if (object == null) {
                    columnDefinitionNode.setType(dataTypeDescriptor);
                    resultColumnList.getResultColumn(columnDefinitionNode.getColumnName(), false).setType(dataTypeDescriptor);
                    this.setCollationTypeOnCharacterStringColumn(schemaDescriptor, columnDefinitionNode);
                    columnDefinitionNode.checkUserType(fromBaseTable.getTableDescriptor());
                } else {
                    TypeId typeId = ((DataTypeDescriptor)object).getTypeId();
                    stringArray = dataTypeDescriptor.getTypeId();
                    if (!this.getTypeCompiler((TypeId)stringArray).convertible(typeId, false)) {
                        throw StandardException.newException("42XA0", columnDefinitionNode.getName(), stringArray.getSQLTypeName());
                    }
                }
                if (!arrayList.isEmpty()) {
                    throw StandardException.newException("42XA1", columnDefinitionNode.getName());
                }
                if (((Hashtable)object2).size() > 0) {
                    generationClauseNode.setAuxiliaryProviderList((ProviderList)object2);
                }
            }
            finally {
                compilerContext.setCurrentAuxiliaryProviderList(providerList);
                compilerContext.setReliability(n2);
            }
            object2 = fromBaseTable.getResultColumns();
            int n3 = ((ResultColumnList)object2).countReferencedColumns();
            object = new int[n3];
            int n4 = ((ResultColumnList)object2).getPosition(columnDefinitionNode.getColumnName(), 1);
            formatableBitSet.set(n4);
            ((ResultColumnList)object2).recordColumnReferences((int[])object, 1);
            stringArray = new String[n3];
            for (int i = 0; i < n3; ++i) {
                stringArray[i] = ((ResultColumn)((QueryTreeNodeVector)object2).elementAt((int)(object[i] - true))).getName();
            }
            String string = this.getLanguageConnectionContext().getCurrentSchemaName();
            DefaultInfoImpl defaultInfoImpl = new DefaultInfoImpl(generationClauseNode.getExpressionText(), stringArray, string);
            columnDefinitionNode.setDefaultInfo(defaultInfoImpl);
            ((ResultColumnList)object2).clearColumnReferences();
        }
    }

    void findIllegalGenerationReferences(FromList fromList, TableDescriptor tableDescriptor) throws StandardException {
        int n;
        ArrayList<ColumnDefinitionNode> arrayList = new ArrayList<ColumnDefinitionNode>();
        HashSet<String> hashSet = new HashSet<String>();
        if (tableDescriptor != null) {
            ColumnDescriptorList columnDescriptorList = tableDescriptor.getGeneratedColumns();
            n = columnDescriptorList.size();
            for (int i = 0; i < n; ++i) {
                hashSet.add(columnDescriptorList.elementAt(i).getColumnName());
            }
        }
        for (TableElementNode tableElementNode : this) {
            ColumnDefinitionNode columnDefinitionNode;
            if (!(tableElementNode instanceof ColumnDefinitionNode) || !(columnDefinitionNode = (ColumnDefinitionNode)tableElementNode).hasGenerationClause()) continue;
            arrayList.add(columnDefinitionNode);
            hashSet.add(columnDefinitionNode.getColumnName());
        }
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            ColumnDefinitionNode columnDefinitionNode = (ColumnDefinitionNode)arrayList.get(n);
            GenerationClauseNode generationClauseNode = columnDefinitionNode.getGenerationClauseNode();
            List<ColumnReference> list = generationClauseNode.findReferencedColumns();
            int n3 = list.size();
            for (int i = 0; i < n3; ++i) {
                String string = list.get(i).getColumnName();
                if (string == null || !hashSet.contains(string)) continue;
                throw StandardException.newException("42XA4", columnDefinitionNode.getColumnName());
            }
        }
    }

    void validateForeignKeysOnGenerationClauses(FromList fromList, FormatableBitSet formatableBitSet) throws StandardException {
        if (formatableBitSet.getNumBitsSet() <= 0) {
            return;
        }
        FromBaseTable fromBaseTable = (FromBaseTable)fromList.elementAt(0);
        ResultColumnList resultColumnList = fromBaseTable.getResultColumns();
        for (TableElementNode tableElementNode : this) {
            if (!(tableElementNode instanceof FKConstraintDefinitionNode)) continue;
            FKConstraintDefinitionNode fKConstraintDefinitionNode = (FKConstraintDefinitionNode)tableElementNode;
            ConstraintInfo constraintInfo = fKConstraintDefinitionNode.getReferencedConstraintInfo();
            int n = constraintInfo.getReferentialActionDeleteRule();
            int n2 = constraintInfo.getReferentialActionUpdateRule();
            if (n2 != 1 && n2 != 2) {
                throw StandardException.newException("XSCB3.S", new Object[0]);
            }
            if (n != 3 && n != 4) continue;
            for (ResultColumn resultColumn : fKConstraintDefinitionNode.getColumnList()) {
                String string = resultColumn.getName();
                int n3 = resultColumnList.getPosition(string, 1);
                if (!formatableBitSet.isSet(n3)) continue;
                throw StandardException.newException("42XA6", string);
            }
        }
    }

    void genConstraintActions(boolean bl, ConstraintConstantAction[] constraintConstantActionArray, String string, SchemaDescriptor schemaDescriptor, DataDictionary dataDictionary) throws StandardException {
        int n = 0;
        for (TableElementNode tableElementNode : this) {
            ProviderInfo[] providerInfoArray;
            String[] stringArray = null;
            IndexConstantAction indexConstantAction = null;
            if (!tableElementNode.hasConstraint() || tableElementNode instanceof ColumnDefinitionNode) continue;
            ConstraintDefinitionNode constraintDefinitionNode = (ConstraintDefinitionNode)tableElementNode;
            if (constraintDefinitionNode.getColumnList() != null) {
                stringArray = new String[constraintDefinitionNode.getColumnList().size()];
                constraintDefinitionNode.getColumnList().exportNames(stringArray);
            }
            int n2 = constraintDefinitionNode.getConstraintType();
            boolean[] blArray = constraintDefinitionNode.getCharacteristics();
            String string2 = constraintDefinitionNode.getConstraintText();
            String string3 = constraintDefinitionNode.getConstraintMoniker();
            if (constraintDefinitionNode.requiresBackingIndex()) {
                if (constraintDefinitionNode.constraintType == 3 && dataDictionary.checkVersion(160, null)) {
                    boolean bl2 = this.areColumnsNullable(constraintDefinitionNode, this.td);
                    boolean bl3 = !bl2;
                    boolean bl4 = bl2;
                    indexConstantAction = this.genIndexAction(bl, bl3, bl4, blArray[0], blArray[1], null, constraintDefinitionNode, stringArray, true, schemaDescriptor, string, n2, dataDictionary);
                } else {
                    indexConstantAction = this.genIndexAction(bl, constraintDefinitionNode.requiresUniqueIndex(), false, blArray[0], blArray[1], null, constraintDefinitionNode, stringArray, true, schemaDescriptor, string, n2, dataDictionary);
                }
            }
            if (n2 == 5) {
                constraintConstantActionArray[n] = this.getGenericConstantActionFactory().getDropConstraintConstantAction(string3, constraintDefinitionNode.getDropSchemaName(), string, this.td.getUUID(), schemaDescriptor.getSchemaName(), indexConstantAction, constraintDefinitionNode.getDropBehavior(), constraintDefinitionNode.getVerifyType());
                continue;
            }
            if (n2 == 7) {
                constraintConstantActionArray[n] = this.getGenericConstantActionFactory().getAlterConstraintConstantAction(string3, constraintDefinitionNode.getDropSchemaName(), blArray, string, this.td.getUUID(), schemaDescriptor.getSchemaName(), indexConstantAction);
                continue;
            }
            ProviderList providerList = constraintDefinitionNode.getAuxiliaryProviderList();
            ConstraintInfo constraintInfo = null;
            if (constraintDefinitionNode instanceof FKConstraintDefinitionNode) {
                constraintInfo = ((FKConstraintDefinitionNode)constraintDefinitionNode).getReferencedConstraintInfo();
            }
            if (providerList != null && providerList.size() > 0) {
                DependencyManager dependencyManager = dataDictionary.getDependencyManager();
                providerInfoArray = dependencyManager.getPersistentProviderInfos(providerList);
            } else {
                providerInfoArray = new ProviderInfo[]{};
            }
            constraintConstantActionArray[n++] = this.getGenericConstantActionFactory().getCreateConstraintConstantAction(string3, n2, blArray, bl, string, this.td != null ? this.td.getUUID() : (UUID)null, schemaDescriptor.getSchemaName(), stringArray, indexConstantAction, string2, constraintInfo, providerInfoArray);
        }
    }

    private boolean columnsMatch(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        int n = stringArray.length;
        int n2 = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            for (int j = 0; j < n2; ++j) {
                if (!stringArray[i].equals(stringArray2[j])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private IndexConstantAction genIndexAction(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string, ConstraintDefinitionNode constraintDefinitionNode, String[] stringArray, boolean bl6, SchemaDescriptor schemaDescriptor, String string2, int n, DataDictionary dataDictionary) throws StandardException {
        if (string == null) {
            string = constraintDefinitionNode.getBackingIndexName(dataDictionary);
        }
        if (n == 5) {
            return this.getGenericConstantActionFactory().getDropIndexConstantAction(null, string, string2, schemaDescriptor.getSchemaName(), this.td.getUUID(), this.td.getHeapConglomerateId());
        }
        boolean[] blArray = new boolean[stringArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = true;
        }
        return this.getGenericConstantActionFactory().getCreateIndexConstantAction(bl, bl2, bl3, bl4, bl5, n, "BTREE", schemaDescriptor.getSchemaName(), string, string2, this.td != null ? this.td.getUUID() : (UUID)null, stringArray, blArray, bl6, constraintDefinitionNode.getBackingIndexUUID(), this.checkIndexPageSizeProperty(constraintDefinitionNode));
    }

    private Properties checkIndexPageSizeProperty(ConstraintDefinitionNode constraintDefinitionNode) throws StandardException {
        Properties properties = constraintDefinitionNode.getProperties();
        if (properties == null) {
            properties = new Properties();
        }
        if (properties.get("derby.storage.pageSize") != null || PropertyUtil.getServiceProperty(this.getLanguageConnectionContext().getTransactionCompile(), "derby.storage.pageSize") != null) {
            return properties;
        }
        int n = 0;
        for (ResultColumn resultColumn : constraintDefinitionNode.getColumnList()) {
            String string = resultColumn.getName();
            DataTypeDescriptor dataTypeDescriptor = this.td == null ? this.getColumnDataTypeDescriptor(string) : this.getColumnDataTypeDescriptor(string, this.td);
            if (dataTypeDescriptor == null) continue;
            n += dataTypeDescriptor.getTypeId().getApproximateLengthInBytes(dataTypeDescriptor);
        }
        if (n > 1024) {
            properties.put("derby.storage.pageSize", "32768");
        }
        return properties;
    }

    private void checkForDuplicateColumns(DDLStatementNode dDLStatementNode, Set<String> set, String string) throws StandardException {
        if (!set.add(string) && dDLStatementNode instanceof CreateTableNode) {
            throw StandardException.newException("42X12", string);
        }
    }

    private void checkForDuplicateConstraintNames(DDLStatementNode dDLStatementNode, Set<String> set, String string) throws StandardException {
        if (string == null) {
            return;
        }
        if (!set.add(string) && dDLStatementNode instanceof CreateTableNode) {
            throw StandardException.newException("42X91", string);
        }
    }

    private void verifyUniqueColumnList(DDLStatementNode dDLStatementNode, ConstraintDefinitionNode constraintDefinitionNode) throws StandardException {
        String string;
        if (dDLStatementNode instanceof CreateTableNode && (string = constraintDefinitionNode.getColumnList().verifyCreateConstraintColumnList(this)) != null) {
            throw StandardException.newException("42X93", dDLStatementNode.getRelativeName(), string);
        }
        string = constraintDefinitionNode.getColumnList().verifyUniqueNames(false);
        if (string != null) {
            throw StandardException.newException("42X92", string);
        }
    }

    private void setColumnListToNotNull(ConstraintDefinitionNode constraintDefinitionNode) {
        for (ResultColumn resultColumn : constraintDefinitionNode.getColumnList()) {
            this.findColumnDefinition(resultColumn.getName()).setNullability(false);
        }
    }

    private boolean areColumnsNullable(ConstraintDefinitionNode constraintDefinitionNode, TableDescriptor tableDescriptor) {
        for (ResultColumn resultColumn : constraintDefinitionNode.getColumnList()) {
            String string = resultColumn.getName();
            DataTypeDescriptor dataTypeDescriptor = tableDescriptor == null ? this.getColumnDataTypeDescriptor(string) : this.getColumnDataTypeDescriptor(string, tableDescriptor);
            if (dataTypeDescriptor == null || !dataTypeDescriptor.isNullable()) continue;
            return true;
        }
        return false;
    }

    private void checkForNullColumns(ConstraintDefinitionNode constraintDefinitionNode, TableDescriptor tableDescriptor) throws StandardException {
        for (ResultColumn resultColumn : constraintDefinitionNode.getColumnList()) {
            DataTypeDescriptor dataTypeDescriptor = tableDescriptor == null ? this.getColumnDataTypeDescriptor(resultColumn.getName()) : this.getColumnDataTypeDescriptor(resultColumn.getName(), tableDescriptor);
            if (dataTypeDescriptor == null || !dataTypeDescriptor.isNullable()) continue;
            String string = this.getLanguageConnectionContext().getDataDictionary().checkVersion(160, null) ? "42831.S.1" : "42831";
            throw StandardException.newException(string, resultColumn.getName());
        }
    }

    private DataTypeDescriptor getColumnDataTypeDescriptor(String string) {
        ColumnDefinitionNode columnDefinitionNode = this.findColumnDefinition(string);
        if (columnDefinitionNode != null) {
            return columnDefinitionNode.getType();
        }
        return null;
    }

    private DataTypeDescriptor getColumnDataTypeDescriptor(String string, TableDescriptor tableDescriptor) {
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(string);
        if (columnDescriptor != null) {
            return columnDescriptor.getType();
        }
        return this.getColumnDataTypeDescriptor(string);
    }

    private ColumnDefinitionNode findColumnDefinition(String string) {
        for (TableElementNode tableElementNode : this) {
            ColumnDefinitionNode columnDefinitionNode;
            if (!(tableElementNode instanceof ColumnDefinitionNode) || !string.equals((columnDefinitionNode = (ColumnDefinitionNode)tableElementNode).getName())) continue;
            return columnDefinitionNode;
        }
        return null;
    }

    boolean containsColumnName(String string) {
        return this.findColumnDefinition(string) != null;
    }
}

