/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.preferences;

import com.jrockit.mc.core.security.SecurelyStoredByteArray;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;

public class JMXRMIPreferences
extends SecurelyStoredByteArray {
    public static final String PROPERTY_KEY_KEYSTORE = "javax.net.ssl.keyStore";
    public static final String PROPERTY_KEY_TRUSTSTORE = "javax.net.ssl.trustStore";
    public static final String PROPERTY_KEY_KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String PROPERTY_KEY_TRUSTSTORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private static final JMXRMIPreferences INSTANCE = new JMXRMIPreferences();
    private Properties cache;

    private JMXRMIPreferences() {
        super("com.jrockit.mc.rjmx.preferences.SslPreferences");
    }

    public static JMXRMIPreferences getInstance() {
        return INSTANCE;
    }

    public void set(byte ... value) throws Exception {
        super.set(value);
        this.buildCache(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties() throws Exception {
        JMXRMIPreferences jMXRMIPreferences = this;
        synchronized (jMXRMIPreferences) {
            if (this.cache != null) {
                return this.cache;
            }
        }
        byte[] bytes = this.get();
        if (bytes != null) {
            return this.buildCache(bytes);
        }
        return null;
    }

    public void remove() throws Exception {
        super.remove();
        this.setCache(null);
    }

    private Properties buildCache(byte[] value) throws IOException {
        Properties props = new Properties();
        props.load(new ByteArrayInputStream(value));
        return this.setCache(props);
    }

    private synchronized Properties setCache(Properties props) {
        this.cache = props;
        return props;
    }
}

